<?php

require_once 'config.php';

function getConnection() {
    try {
        $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8';
        $pdo = new PDO($dsn, DB_USER, DB_PASS);

        // Configura o PDO para lançar exceções em caso de erro
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        return $pdo;
    } catch (PDOException $e) {
        // Grava erro em log local
        file_put_contents('logs/erro_conexao.txt', date('Y-m-d H:i:s') . " | Erro de conexão: " . $e->getMessage() . PHP_EOL, FILE_APPEND);

        // Responde com erro HTTP 500
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao conectar ao banco de dados.']);
        exit;
    }
}
